#define SST_Create
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = STRING - The path and filename of the SST.dll
argument1 = REAL - Whether to enable the "advance" mode or not
===
return = REAL - An instance ID to the sst object or -1 if failed
===
//Com:
      This should be used first to setup the STT.dll in Game Maker.
      
      Note that you MUST make a "dummy" object called sst in order for this
      to work.  This script takes care of defining the object's parameters.
*/
if (instance_exists(sst)) { return 0; };
object_set_persistent(sst,1);

object_event_add(sst,ev_create,0,'SST_Internal(0,"'+argument0+'");');
object_event_add(sst,ev_destroy,0,"SST_Internal(1);");
object_event_add(sst,ev_other,ev_game_end,"instance_destroy();");
if (argument1) {
   object_event_add(sst,ev_step,ev_step_begin,"input = external_call(GetInput); if (input > 511 and input < 522) { event_user(input-512); };");
};

var index; index = instance_create(0,0,sst);

return index;
#define SST_Internal
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
//Com:
      This should NOT be called by the user.  This is for internal use only.
*/
switch (argument0) {
       case 0:
            dll = argument1;
            
            //SST_Notify()
            NIM_ADD     = 0;
            NIM_MODIFY  = 1;
            NIM_DELETE  = 2;
            
            //SST_GetInput()
            WM_MOUSEMOVE        = 512; /*Mouse over*/
            WM_LBUTTONDOWN      = 513;
            WM_LBUTTONUP        = 514;
            WM_LBUTTONDBLCLK    = 515;
            WM_RBUTTONDOWN      = 516;
            WM_RBUTTONUP        = 517;
            WM_RBUTTONDBLCLK    = 518;
            WM_MBUTTONDOWN      = 519;
            WM_MBUTTONUP        = 520;
            WM_MBUTTONDBLCLK    = 521;
            
            //SST_ShowWindow()
            SW_HIDE             = 0;
            SW_SHOWNORMAL       = 1;
            SW_SHOWMINIMIZED    = 2;
            SW_SHOWMAXIMIZED    = 3;
            SW_SHOWNOACTIVE     = 4;
            SW_SHOW             = 5;
            SW_MINIMIZE         = 6;
            SW_SHOWMINNOACTIVE  = 7;
            SW_SHOWNA           = 8;
            SW_RESTORE          = 9;
            SW_SHOWDEFAULT      = 10;
            SW_FORCEMINIMIZE    = 11;
            
            //SST_SetWindowPos()
            HWND_TOPMOST        = -3;
            HWND_NOTTOPMOST     = -2;
            HWND_TOP            = 0;
            HWND_BOTTOM         = 1;

            SWP_NOSIZE          = 1;
            SWP_NOMOVE          = 2;
            SWP_NOZORDER        = 4;
            SWP_NOREDRAW        = 8;
            SWP_NOACTIVATE      = 16;
            /*SWP_DRAWFRAME     = 32;*/
            SWP_SHOWWINDOW      = 64;
            SWP_HIDEWINDOW      = 128;
            /*SWP_NOCOPYBITS    = 256;*/
            SWP_NOREPOSITION    = 512;
            
            //SST_MessageBox()
            MB_OK               = 0;
            MB_OKCANCEL         = 1;
            MB_ABORTRETRYIGNORE = 2;
            MB_YESNOCANCEL      = 3;
            MB_YESNO            = 4;
            MB_RETRYCANCEL      = 5;

            MB_ICONERROR        = 16;
            MB_ICONQUESTION     = 32;
            MB_ICONEXCLAMATION  = 48;
            MB_ICONINFORMATION  = 64;

            IDOK                = 1;
            IDCANCEL            = 2;
            IDABORT             = 3;
            IDRETRY             = 4;
            IDIGNORE            = 5;
            IDYES               = 6;
            IDNO                = 7;
            
            SetHandles = external_define(dll,"SST_SetHandles",dll_cdecl,ty_real,1,ty_real);
            LoadIcon = external_define(dll,"SST_LoadIcon",dll_cdecl,ty_real,1,ty_string);
            SetToolTip = external_define(dll,"SST_SetToolTip",dll_cdecl,ty_real,1,ty_string);
            Notify = external_define(dll,"SST_Notify",dll_cdecl,ty_real,1,ty_real);
            GetInput = external_define(dll,"SST_GetInput",dll_cdecl,ty_real,0);
            IsIconic = external_define(dll,"SST_IsIconic",dll_cdecl,ty_real,0);
            SetForegroundWindow = external_define(dll,"SST_SetForegroundWindow",dll_cdecl,ty_real,1,ty_real);
            ShowWindow = external_define(dll,"SST_ShowWindow",dll_cdecl,ty_real,2,ty_real,ty_real);
            SetWindowPos = external_define(dll,"SST_SetWindowPos",dll_cdecl,ty_real,7,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
            SetWindowText = external_define(dll,"SST_SetWindowText",dll_cdecl,ty_real,2,ty_real,ty_string);
            MessageBox = external_define(dll,"SST_MessageBox",dll_cdecl,ty_real,3,ty_string,ty_string,ty_real);
            WindowProcedure = external_define(dll,"SST_WindowProcedure",dll_cdecl,ty_real,1,ty_real);
            GetTrayStatus = external_define(dll,"SST_GetTrayStatus",dll_cdecl,ty_real,0);
            break;
       case 1:
            if (external_call(GetTrayStatus)) { external_call(Notify,NIM_DELETE); };
            external_call(WindowProcedure,0);
            external_free(dll);
            break;
};
#define SST_SetHandles
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = REAL - The local window handle
===
return = REAL - The parent window handle
===
//Com:
      This should be used after creating the SST.  Many of the functions
      require the local and parent window handles.
      
      All you need to pass is the current local handle (use window_handle()).
      The parent is automatically pulled from this and returned.
      
      You can use the parent handle in functions like SST_ShowWindow().
*/
return external_call(sst.SetHandles,argument0);
#define SST_LoadIcon
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = STRING - The path and filename of the icon to display
===
return = REAL - 1 if Successful, or 0 if failure.
===
//Com:
      Used to load an icon for the system tray.  The icon must be a .ico file
      and should be 16x16.  However, if the icon is larger/smaller, it will
      be scaled by the operating system.
*/
return external_call(sst.LoadIcon,argument0);
#define SST_SetToolTip
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = STRING - Text to display in the Tool Tip
===
return = NULL
===
//Com:
      When you hover the mouse over the system tray icon, a Tool Tip text
      is display.  This function can be used to set what this displays.
*/
return external_call(sst.SetToolTip,argument0);
#define SST_Notify
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = REAL - Whether to ADD, MODIFY or DELETE the system tray.
===
return = REAL - Truely...I have no idea
===
//Com:
      Once you've set the data for your system tray, use this to add it.
      (or actually display/create the system tray icon).
      
      For the argument, there are three (3) different options:
      NIM_ADD - Used to initially create the system tray icon
      NIM_MODIFY - To update changes you made (like the icon or tooltip)
      NIM_DELETE - Will remove the icon from the system tray
      
      You only need to use ADD initially, from then on, you should use
      MODIFY for changes.  If you make changes to the icon or tool tip text,
      you need to follow them by this function using MODIFY to actually
      have the changes take effect.  Once you are done, use DELETE to remove
      the icon from the tray.
*/
return external_call(sst.Notify,argument0);
#define SST_GetInput
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
No Arguments
===
return = REAL - A mouse button state
===
//Com:
      Once you setup the system tray icon, you need to check for input.
      
      This should be called every step.
      
      The return value is from 512 to 521, the actual list of constants
      is located in the SST_Internal() script.
*/
return external_call(sst.GetInput);
#define SST_IsIconic
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
No Arguments
===
return = REAL - Whether Iconic (1) or not (0)
===
//Com:
      Don't be fooled by it's bizarre name.  This basically checks to see if
      a window is Minimized or not.  The name is based directly off the winAPI
      function name for simplicity.
*/
return external_call(sst.IsIconic);
#define SST_SetForegroundWindow
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = REAL - The window handle to set in focus
===
return = REAL - NULL
===
//Com:
      This function can be used to set a window in focus (or in front).  When
      it comes to GM games, you should use the local handle for this.
*/
return external_call(sst.SetForegroundWindow,argument0);
#define SST_ShowWindow
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = REAL - The handle to a window to 'show'
argument1 = REAL - Style to set to the window
===
return = NULL
===
//Com:
      Used to show, hide, minimize, maximize, etc...to a window.  The list of
      acceptable styles are in SST_Internal().
      
      When it comes to Game Maker applications, you should pass the parent
      handle to this function (otherwise you'll get some bizarre behavior).
*/
return external_call(sst.ShowWindow,argument0,argument1);
#define SST_SetWindowPos
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = REAL - Window handle to manipulate
argument1 = REAL - The Z-Order position of the window: HWND_
argument2 = REAL - The X position
argument3 = REAL - The Y position
argument4 = REAL - The Width
argument5 = REAL - The Height
argument6 = REAL - Any additional flags: SWP_
===
return = NULL
===
//Com:
      This can be used to further manipulate a window.  You can set it's
      position, dimentions and Z-Order...along with a few additional settings.
      
      The constants for this function can be found in the SST_Internal()
      function.
      
      When it comes to Game Maker applications, you should pass the parent
      handle to this function.
*/
return external_call(sst.SetWindowPos,argument0,argument1,argument2,argument3,argument4,argument5,argument6);
#define SST_SetWindowText
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = REAL - The window handle to change taskbar text
argument1 = STRING - The text to set
===
return = NULL
===
//Com:
      This is used to change the window text for a window.
      
      Mainly I added this so that you could change GM's taskbar text, which
      is normally not under your control.
      
      To do so, enter Game Maker's parent handle for argument0.  Then
      the text you want to show.
*/
return external_call(sst.SetWindowText,argument0,argument1);
#define SST_MessageBox
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = STRING - The message
argument1 = STRING - The label
argument2 = REAL - The button|icon setup to use
===
return = REAL - The button which was clicked
===
//Com:
      I think enough people have seen a MessageBox function before...but here
      we go again.
      
      Argument0 is the message contained in the message box.  Argument1 is the
      window text (or label) for the message box.
      
      Now the last argument allows you to set what buttons are avaliable and
      type of icon to show in the message box.  The constants avaliable are
      shown in SST_Internal().
      
      When setting both a button and icon, seperate the constants by a |
      
      ex:  sst.MB_OK|sst.MB_ICONINFORMATION
*/
return external_call(sst.MessageBox,argument0,argument1,argument2);
#define SST_WindowProcedure
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
argument0 = REAL - Whether to enable (1) or disable (0) the sub procedure
===
return = NULL
===
//Com:
      For the SST to get mouse input, it needs to subclass the Game Maker
      window procedure.  This function allows you to enable/disable this.
*/
return external_call(sst.WindowProcedure,argument0);
#define SST_Close
/*Shaltif's System Tray
--Your solution to Game Maker system tray support
--Brandon Rohrer  2005-2006
=================================================
No Arguments
===
return = REAL - Successful (1) or failed (0)
===
//Com:
      Use this to close and clear the SST support.  You do "not" need to call
      this on game end (SST takes care of itself in that case).  However, it
      is good practice to close/clear something your done working with, even
      when the game is closing ;)
*/
if (!instance_exists(sst)) { return 0; };
with (sst) { instance_destroy(); };

object_event_clear(sst,ev_create,0);
object_event_clear(sst,ev_destroy,0);
object_event_clear(sst,ev_other,ev_game_end);
object_event_clear(sst,ev_step,ev_step_begin);
object_event_clear(sst,ev_other,ev_user0);
object_event_clear(sst,ev_other,ev_user1);
object_event_clear(sst,ev_other,ev_user2);
object_event_clear(sst,ev_other,ev_user3);
object_event_clear(sst,ev_other,ev_user4);
object_event_clear(sst,ev_other,ev_user5);
object_event_clear(sst,ev_other,ev_user6);
object_event_clear(sst,ev_other,ev_user7);
object_event_clear(sst,ev_other,ev_user8);
object_event_clear(sst,ev_other,ev_user9);

object_set_persistent(sst,0);

return 1;
